/*
 * Decompiled with CFR 0.152.
 */
package apicore.message;

import apicore.message.LTV;
import apicore.ptmp.EncodedBuffer;

public class IPCResponseLTV
extends LTV {
    protected int messageId;
    protected Object innerValue;

    public IPCResponseLTV(int n) {
        this.messageId = n;
        this.setType(102);
    }

    public boolean isResponse() {
        return true;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void encodeTypeAndPayload(EncodedBuffer encodedBuffer) {
        encodedBuffer.putInt(this.getType());
        encodedBuffer.putInt(this.messageId);
        encodedBuffer.putByte((byte)2);
        encodedBuffer.putBool(this.getBoolValue());
        encodedBuffer.putByte((byte)0);
    }

    public boolean getBoolValue() {
        this.checkInnerValue();
        return (Boolean)this.innerValue;
    }

    public byte getByteValue() {
        this.checkInnerValue();
        return (Byte)this.innerValue;
    }

    public double getDoubleValue() {
        this.checkInnerValue();
        return (Double)this.innerValue;
    }

    public float getFloatValue() {
        this.checkInnerValue();
        return ((Float)this.innerValue).floatValue();
    }

    public int getIntValue() {
        this.checkInnerValue();
        return (Integer)this.innerValue;
    }

    public long getLongValue() {
        this.checkInnerValue();
        return (Long)this.innerValue;
    }

    public Object getObjectValue() {
        return this.innerValue;
    }

    public short getShortValue() {
        this.checkInnerValue();
        return (Short)this.innerValue;
    }

    public String getStringValue() {
        return (String)this.innerValue;
    }

    public void setValue(Object object) {
        this.innerValue = object;
    }

    protected void checkInnerValue() {
        if (this.innerValue == null) {
            throw new Error("Attempt to retrieve primitive value from a null IPCResponseLTV");
        }
    }
}

